#ifndef SIMPLEREADTEST_H
#define SIMPLEREADTEST_H

#include <QObject>
#include <QTime>

#include <QrfeReaderInterface.h>
#include <protocol/QrfeProtocolHandler.h>

class SimpleReadTest : public QObject
{
    Q_OBJECT
public:
    explicit SimpleReadTest(QObject *parent = 0);

    void init(QString serialPort);
    void init(QString ip, ushort port);

private:
    void init(QIODevice* dev);

public slots:
    void start();
    void stop();

private slots:
    void heartBeat ();
    void cyclicInventory (const QrfeReaderInterface::QrfeTagEvent &tagInfo);

    void print(const QString& str = QString());


private:
    QrfeReaderInterface::QrfeProtocolHandler* m_ph;
    QrfeReaderInterface::QrfeTraceInterface*  m_trc;

    QTime       m_heartBeatTime;

    QTime       m_cyclicInvTime;
    ulong       m_cyclicInvCount;
};

#endif // SIMPLEREADTEST_H
